% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadataAccessors.R
\name{coreMetadata}
\alias{coreMetadata}
\alias{globalMetadata}
\alias{seriesMetadata}
\alias{metadata,ANY-method}
\alias{metadata,AnnotatedImage-method}
\alias{metadata,AnnotatedImageList-method}
\alias{metadata,ImageMetadata-method}
\alias{metadata,ImageMetadataList-method}
\alias{metadata<-,AnnotatedImage-method}
\alias{coreMetadata<-}
\alias{coreMetadata<-,AnnotatedImage-method}
\alias{coreMetadata<-,ImageMetadata-method}
\alias{globalMetadata<-}
\alias{globalMetadata<-,AnnotatedImage-method}
\alias{globalMetadata<-,ImageMetadata-method}
\alias{seriesMetadata<-}
\alias{seriesMetadata<-,AnnotatedImage-method}
\alias{seriesMetadata<-,ImageMetadata-method}
\title{Metadata Accessors}
\usage{
coreMetadata(x, series, ...)

globalMetadata(x, series, ...)

seriesMetadata(x, series, ...)

\S4method{metadata}{ANY}(x)

\S4method{metadata}{AnnotatedImage}(x)

\S4method{metadata}{AnnotatedImageList}(x)

\S4method{metadata}{ImageMetadata}(x)

\S4method{metadata}{ImageMetadataList}(x)

\S4method{metadata}{AnnotatedImage}(x) <- value

coreMetadata(y) <- value

\S4method{coreMetadata}{AnnotatedImage}(y) <- value

\S4method{coreMetadata}{ImageMetadata}(y) <- value

globalMetadata(y) <- value

\S4method{globalMetadata}{AnnotatedImage}(y) <- value

\S4method{globalMetadata}{ImageMetadata}(y) <- value

seriesMetadata(y) <- value

\S4method{seriesMetadata}{AnnotatedImage}(y) <- value

\S4method{seriesMetadata}{ImageMetadata}(y) <- value
}
\arguments{
\item{x}{an \linkS4class{AnnotatedImage}, \linkS4class{AnnotatedImageList}, \linkS4class{ImageMetadata}, or \linkS4class{ImageMetadataList} object}

\item{series}{series ID}

\item{...}{arguments passed to \code{\link[base]{grep}}}

\item{value}{depending on the context, an \linkS4class{ImageMetadata} object or a list}

\item{y}{an \linkS4class{AnnotatedImage} or \linkS4class{ImageMetadata} object}
}
\value{
Named list consisting of key value pairs.
}
\description{
Get and set image metadata.
}
\details{
The \ldots arguments are passed to \code{\link[base]{grep}} called on metadata names allowing for convenient subsetting.
}
\examples{
img = read.image(system.file("images", "nuclei.tif", package="EBImage"))

coreMetadata(img)

# subset for specific names

globalMetadata(img, pattern="Image")
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2014-2023
}
