% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_dNBllrow.R
\name{dNBllrow}
\alias{dNBllrow}
\title{A score function of the NB for the row scores}
\usage{
dNBllrow(
  beta,
  X,
  reg,
  thetas,
  muMarg,
  k,
  n,
  p,
  rowWeights,
  nLambda,
  rMatK,
  allowMissingness,
  naId,
  ...
)
}
\arguments{
\item{beta}{a vector of of length n + k +1 regression parameters to optimize}

\item{X}{the data matrix of dimensions nxp}

\item{reg}{a 1xp regressor matrix: outer product of column scores and psis}

\item{thetas}{nxp matrix with the dispersion parameters
(converted to matrix for numeric reasons)}

\item{muMarg}{an nxp offset matrix}

\item{k}{a scalar, the dimension of the RC solution}

\item{n}{a scalar, the number of samples}

\item{p}{a scalar, the number of taxa}

\item{rowWeights}{a vector of length n, the weights used for the restrictions}

\item{nLambda}{an integer, the number of lagrangian multipliers}

\item{rMatK}{the lower dimension row scores}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X}

\item{...}{Other arguments passed on to the jacobian}
}
\value{
A vector of length n + k +1 with evaluations of the
 derivative of the lagrangian
}
\description{
A score function of the NB for the row scores
}
