% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_estNBparamsNoLab.R
\name{estNBparamsNoLab}
\alias{estNBparamsNoLab}
\title{A function to estimate the NB-params ignoring the taxon labels}
\usage{
estNBparamsNoLab(
  design,
  thetasMat,
  muMarg,
  psi,
  X,
  nleqslv.control,
  initParam,
  n,
  v,
  dynamic,
  envRange,
  preFabMat,
  allowMissingness,
  naId
)
}
\arguments{
\item{design}{an n-by-v design matrix}

\item{thetasMat}{A matrix of dispersion parameters}

\item{muMarg}{an offset matrix}

\item{psi}{a scalar, the importance parameter}

\item{X}{the data matrix}

\item{nleqslv.control}{a list of control elements, passed on to nleqslv()}

\item{initParam}{a vector of length v of initial parameter estimates}

\item{n}{an integer, the number of samples}

\item{v}{an integer, the number of parameters per taxon}

\item{dynamic}{a boolean, should response function be determined dynamically?
See details}

\item{envRange}{a vector of length 2,
giving the range of observed environmental scores}

\item{preFabMat}{a pre-fabricated auxiliary matrix}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X

If dynamic is TRUE, quadratic response functions are fitted for every taxon.
 If the optimum falls outside of the observed range of environmental scores,
 a linear response function is fitted instead}
}
\value{
a v-by-p matrix of parameters of the response function
}
\description{
A function to estimate the NB-params ignoring the taxon labels
}
