% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_respFunJacMat.R
\name{respFunJacMat}
\alias{respFunJacMat}
\title{Calculates the Jacobian of the parametric response functions}
\usage{
respFunJacMat(
  betas,
  X,
  reg,
  thetaMat,
  muMarg,
  psi,
  v,
  p,
  IDmat,
  IndVec,
  allowMissingness,
  naId
)
}
\arguments{
\item{betas}{a vector of length (deg+1)*(p+1) with regression parameters
with deg the degree of the response function and the lagrangian multipliers}

\item{X}{the nxp data matrix}

\item{reg}{a vector of regressors with the dimension n-by-v}

\item{thetaMat}{The n-by-p matrix with dispersion parameters}

\item{muMarg}{offset matrix of size nxp}

\item{psi}{a scalar, the importance parameter}

\item{v}{an integer, one plus the degree of the response function}

\item{p}{an integer, the number of taxa}

\item{IDmat}{an logical matrix with indices of non-zero elements}

\item{IndVec}{a vector with indices with non-zero elements}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X}
}
\value{
The jacobian, a square matrix of dimension (deg+1)*(p+1)
}
\description{
Calculates the Jacobian of the parametric response functions
}
