% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Session.R
\name{closeSession}
\alias{closeSession}
\title{Close Session}
\usage{
closeSession(save.before.closing, filename = NULL, base.url = .defaultBaseUrl)
}
\arguments{
\item{save.before.closing}{\code{boolean} Whether to save before closing the
current session. If FALSE, then all unsaved work will be lost.}

\item{filename}{(optional) If \code{save.before.closing} is TRUE and the 
session has not previously been saved, then the path and name of the session 
file to save should be provided. Default is NULL.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Closes the current session in Cytoscape, destroying all unsaved
work.
}
\details{
A boolean for whether to save before closing is required since you
could lose data by closing without saving.
}
\examples{
\donttest{
closeSession(FALSE)
closeSession(TRUE, '/fullpath/mySession')
closeSession(TRUE)
}
}
