% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Layouts.R
\name{getLayoutNameMapping}
\alias{getLayoutNameMapping}
\title{Get Layout Name Mapping}
\usage{
getLayoutNameMapping(base.url = .defaultBaseUrl)
}
\arguments{
\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A named \code{list} of \code{character} strings
}
\description{
The Cytoscape 'Layout' menu lists many layout algorithms, but the names presented 
there are different from the names by which these algorithms are known to layout method. This 
method returns a named list in which the names are from the GUI, and the values identify the 
names you must use to choose an algorithms in the programmatic interface.
}
\examples{
\donttest{
getLayoutNameMapping()
# Degree Sorted Circle Layout    Group Attributes Layout    Edge-weighted Spring Embedded Layout 
#              "degree-circle"       "attributes-layout"                          "kamada-kawai" 
}
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
