% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleBypasses.R
\name{setNodeTooltipBypass}
\alias{setNodeTooltipBypass}
\title{Set Node Tooltip Bypass}
\usage{
setNodeTooltipBypass(
  node.names,
  new.tooltip,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{node.names}{List of node names or SUIDs}

\item{new.tooltip}{List of tooltips, or a single tooltip}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Sets a bypass tooltip for one or more nodes
}
\details{
This method permanently overrides any default values or mappings 
defined for this visual property of the node or nodes specified. This method
ultimately calls the generic function, \link{setNodePropertyBypass}, which 
can be used to set any visual property. To restore defaults and mappings, use
 \link{clearNodePropertyBypass}, see examples.
}
\examples{
\donttest{
setNodeTooltipBypass('Node 1', 'This is an important node.')
}
}
\seealso{
{
\link{setNodePropertyBypass},
\link{clearNodePropertyBypass}
}
}
