% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleMappings.R
\name{updateStyleMapping}
\alias{updateStyleMapping}
\title{Updates a visual property mapping in a style}
\usage{
updateStyleMapping(style.name, mapping, base.url = .defaultBaseUrl)
}
\arguments{
\item{style.name}{(char) name for style}

\item{mapping}{a single visual property mapping, see mapVisualProperty}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
server response
}
\description{
Updates the visual property mapping, overriding any prior mapping. Creates a
visual property mapping if it doesn't already exist in the style.
}
\details{
Requires visual property mappings to be previously created, see mapVisualProperty.
}
\examples{
\donttest{
updateStyleMapping('myStyle',mapVisualProperty('node label','name','p'))
}
}
\seealso{
mapVisualProperty
}
