% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_network.R
\name{network_overlap}
\alias{network_overlap}
\title{network_overlap}
\usage{
network_overlap(
  gene_list = NA,
  resources = c("PID", "TFe", "dPPI", "CCSB", "STRING"),
  minStringScore = 700,
  minHumanNetScore = 0.4,
  minScore = 0,
  verbose = TRUE,
  dedup = TRUE,
  directed_net = FALSE,
  include_neighbors = FALSE,
  STRING_cache_directory = NA,
  STRING_species = 9606,
  STRING_version = "10"
)
}
\arguments{
\item{gene_list}{A list of genes to use. The function will identify edges across resources for or among these genes; identify the induced subnetwork around the gene_list.}

\item{resources}{Name of network resource(s) to use.}

\item{minStringScore}{If STRING is among the resources, only edges of at least the indicated score will be included.}

\item{minHumanNetScore}{If HumanNet is among the resources, only edges of at least the indicated score will be included.}

\item{minScore}{Same as above, but used for any other networks where "score" is provided}

\item{verbose}{If TRUE (default), the function will update the user on what it is doing and how many edges are identified for each resource.}

\item{dedup}{If TRUE (Default = TRUE), remove edges reported by multiple resources. The edge type will be a semi-colon delimited list of the resources that had reported the interaction.}

\item{directed_net}{Logical indicating if the network resources should be interpreted as directed.}

\item{include_neighbors}{Logical to include 1st neighbors of "gene_list" (genes not in gene_list, but directly connected to them) in the induced subnetwork.}

\item{STRING_cache_directory}{A directory where STRING data files are cached to speed up subsequent queries; no need to re-download. If NA (the default), caches STRING data in your Rpackages directory. If "", uses a temporary directory that is cleared when the R-session closes.}

\item{STRING_species}{Species taxon ID (number) to use in searching STRING data. (Default = 9606)}

\item{STRING_version}{Version of the STRING database (Default = "10")}
}
\value{
Data table describing the induced subnetwork for "gene_list" across the requested resources.
}
\description{
network_overlap
}
\examples{
## Get interactions among a list of genes from the PID: Pathway Interaction Database
require(RITANdata)
myGeneSet <- c('BRCA1','RAD51C','VAV1','HRAS','ABCC1','CYP1B1','CYP3A5')
sif <- network_overlap( myGeneSet, resources = 'PID')
print(sif)

\dontrun{
## Get the PPI network induced by genes within myGeneSet
## Use 4 separate resources, but trim STRING to only include more confident interactions
sif <- network_overlap( myGeneSet, c('dPPI','PID','CCSB','STRING'), minStringScore = 500 )
}
}
