% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPosteriors.R
\name{plotPosteriors}
\alias{plotPosteriors}
\title{Draw scatter plots of posterior probabilities from both RIVER GAM in terms
        of outlier status.}
\usage{
plotPosteriors(postprobs, outliers)
}
\arguments{
\item{postprobs}{Output of \code{evaRIVER}, which provides test posterior
probabilities from both RIVER and GAM for all instances.}

\item{outliers}{Outlier status of examples}
}
\value{
A figure of posteriors from RIVER (y-axis) and GAM (x-axis) models
        for ouliters and non-outliers separately
}
\description{
\code{plotPosteriors} draws scatter plots of posterior probabilities from
        both RIVER GAM (genomic annotation model) in terms of outlier
        status.
}
\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
postprobs <- appRIVER(dataInput)
plotPosteriors(postprobs, outliers=as.numeric(unlist(dataInput$Outlier))-1)

}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
