% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJMCMCNucleosomes.R
\docType{data}
\name{syntheticNucleosomeReads}
\alias{syntheticNucleosomeReads}
\title{Simulated dataset of reads generated by \code{nucleoSim} package
(for demo purpose).}
\format{A \code{list} containing:
\itemize{
    \item \code{call} the called that generated the dataset.
    \item \code{dataIP} a \code{data.frame} with the chromosome name, the
    starting and ending positions and the direction of all forward and
    reverse reads for all well-positioned and fuzzy nucleosomes. Paired-end
    reads are identified with an unique id.
    \item \code{wp} a \code{data.frame} with the positions of all the
    well-positioned nucleosomes, as well as the number of paired-reads
    associated to each one.
    \item \code{fuz} a \code{data.frame} with the positions of all the
    fuzzy nucleosomes, as well as the number of paired-reads associated
    to each one.
    \item \code{paired} a \code{data.frame} with the starting and ending
    positions of the reads used to generate the paired-end reads.
    Paired-end reads are identified with an unique id.
}}
\usage{
data(syntheticNucleosomeReads)
}
\value{
A \code{list} containing:
\itemize{
    \item \code{call} the called that generated the dataset.
    \item \code{dataIP} a \code{data.frame} with the chromosome name, the
    starting and ending positions and the direction of all forward and
    reverse reads for all well-positioned and fuzzy nucleosomes. Paired-end
    reads are identified with an unique id.
    \item \code{wp} a \code{data.frame} with the positions of all the
    well-positioned nucleosomes, as well as the number of paired-reads
    associated to each one.
    \item \code{fuz} a \code{data.frame} with the positions of all the
    fuzzy nucleosomes, as well as the number of paired-reads associated
    to each one.
    \item \code{paired} a \code{data.frame} with the starting and ending
    positions of the reads used to generate the paired-end reads.
    Paired-end reads are identified with an unique id.
}
}
\description{
A \code{list} of \code{class}
"syntheticNucReads" which contains the information about synthetic reads
related to nucleosomes. The datset has been created using a total of 300
well-positioned nucleosomes, 30 fuzzy nucleosomes with variance of reads
following a Normal distribution.
}
\keyword{datasets}
