% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leCsvAccess.R
\name{loadList}
\alias{loadList}
\alias{resetList}
\title{Load compound list for RMassBank}
\usage{
loadList(path, listEnv=NULL, check=TRUE)

resetList()
}
\arguments{
\item{path}{Path to the CSV list.}

\item{listEnv}{The environment to load the list into. By default, the namelist is loaded
into an environment internally in RMassBank.}

\item{check}{A parameter that specifies whether the SMILES-Codes in the list should be checked for readability by rcdk.}
}
\value{
No return value.
}
\description{
Loads a CSV compound list with compound IDs
}
\details{
The list is loaded into the variable \code{\var{compoundList}} in the environment
\code{listEnv} (which defaults to the global environment) and used by
the \code{findMz}, \code{findCAS}, ... functions. The CSV file is required to have at least the following columns, which are used for 
further processing and must be named correctly (but present in any order): \var{ID, Name, SMILES, RT,
CAS}

resetList() clears a currently loaded list.
}
\examples{

##
\dontrun{loadList("mylist.csv")}

}
\seealso{
\code{\link{findMz}}
}
\author{
Michael Stravs
}
