% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpAUCboot.R
\name{mcpAUCboot}
\alias{mcpAUCboot}
\title{mcpAUCboot}
\usage{
mcpAUCboot(
  dataset,
  low.value = NULL,
  up.value = NULL,
  r = 50,
  level = 0.95,
  type.interval = "perc",
  selection = NULL,
  variable = NULL
)
}
\arguments{
\item{dataset}{dataframe or RangedSummarizedExperiment objetc}

\item{low.value}{lower false positive rate value that the function
will use to calculate the pAUC}

\item{up.value}{upper false positive rate value that the function
will use to calculate the pAUC}

\item{r}{number of iterations.}

\item{level}{confidence level}

\item{type.interval}{String that represent the type of intervals required.
The value should be any subset of the values
c("norm","basic", "stud", "perc", "bca")
or simply "all" which will compute all five types of intervals.}

\item{selection}{vector that will only be used if the parameter
"dataset" is a RangedSummarizedExperiment object.
This parameter is used to select the variables that will be analysed}

\item{variable}{in case that dataset is a  SummarizedExperiment,
indicate the Gold Standard}
}
\value{
SummarizedExperiment object with the mcpAUC, the standard
 desviation, and the lower and upper limits of the confidence interval.
}
\description{
Calculates the confidence interval using a boot analysis
}
\examples{
library(fission)
data("fission")
resultsMCboot <- mcpAUCboot(fission,low.value = 0, up.value = 0.25,
selection = c("SPNCRNA.1080","SPAC186.08c"), variable="strain")
}
