% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_probedata_hitchip.R
\name{summarize_probedata}
\alias{summarize_probedata}
\title{Summarize probedata}
\usage{
summarize_probedata(
  data.dir = NULL,
  probedata = NULL,
  taxonomy = NULL,
  level,
  method,
  probe.parameters = NULL
)
}
\arguments{
\item{data.dir}{Data folder.}

\item{probedata}{probe-level data matrix in absolute domain}

\item{taxonomy}{probe taxonomy}

\item{level}{Summarization level}

\item{method}{Summarization method}

\item{probe.parameters}{Precalculater probe parameters. Optional.}
}
\value{
data matrix (taxa x samples)
}
\description{
Summarize phylogenetic microarray probe-level data from given input folder.
}
\examples{
\dontrun{
#library(microbiome)
#data.directory <- system.file("extdata", package = "microbiome")
# Read oligo-level data (here: simulated example data)
#probedata <- read_hitchip(data.directory, method = "frpa")$probedata
# Read phylogeny map
# NOTE: use phylogeny.filtered for species/L1/L2 summarization
# Load taxonomy from output directory
#taxonomy <- GetPhylogeny("HITChip", "filtered")
# Summarize oligos into higher level phylotypes
#dat <- summarize_probedata(
#                 probedata = probedata,
#		 taxonomy = taxonomy, 
#                method = "rpa",
#		 level = "species")
#}
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
