% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFirehoseData.R
\name{getFirehoseData}
\alias{getFirehoseData}
\title{Get data from Firehose portal.}
\usage{
getFirehoseData(
  dataset,
  runDate = "20160128",
  gistic2Date = "20160128",
  RNASeqGene = FALSE,
  RNASeq2Gene = FALSE,
  clinical = TRUE,
  miRNASeqGene = FALSE,
  miRNASeqGeneType = c("read_count", "reads_per_million_miRNA_mapped", "cross-mapped"),
  RNASeq2GeneNorm = FALSE,
  CNASNP = FALSE,
  CNVSNP = FALSE,
  CNASeq = FALSE,
  CNACGH = FALSE,
  Methylation = FALSE,
  Mutation = FALSE,
  mRNAArray = FALSE,
  miRNAArray = FALSE,
  RPPAArray = FALSE,
  GISTIC = FALSE,
  RNAseqNorm = "raw_count",
  RNAseq2Norm = c("normalized_counts", "RSEM_normalized_log2", "raw_counts",
    "scaled_estimate"),
  forceDownload = FALSE,
  destdir = .setCache(),
  fileSizeLimit = 500,
  getUUIDs = FALSE,
  ...
)
}
\arguments{
\item{dataset}{A cohort disease code. TCGA cancer codes can be obtained via
\link{getFirehoseDatasets}}

\item{runDate}{Standard data run dates. Date list can be accessible via
\link{getFirehoseRunningDates}}

\item{gistic2Date}{Analysis run date for GISTIC obtained via
\link{getFirehoseAnalyzeDates}}

\item{RNASeqGene}{Logical (default FALSE) RNAseq TPM data.}

\item{RNASeq2Gene}{Logical (default FALSE) RNAseq v2 (RSEM processed) data;
see \code{RNAseqNorm} argument.}

\item{clinical}{Logical (default TRUE) clinical data.}

\item{miRNASeqGene}{Logical (default FALSE) smallRNAseq data.}

\item{miRNASeqGeneType}{Character (default "read_count") Indicate which type
of data should be pulled from the miRNASeqGene data. Must be one of
"reads_per_million_miRNA_mapped", "read_count", or "cross-mapped".}

\item{RNASeq2GeneNorm}{Logical (default FALSE) RNAseq v2 (RSEM processed)
data.}

\item{CNASNP}{Logical (default FALSE) somatic copy number alterations data
from SNP array.}

\item{CNVSNP}{Logical (default FALSE) germline copy number variants data from
SNP array.}

\item{CNASeq}{Logical (default FALSE) somatic copy number alterations data
from sequencing.}

\item{CNACGH}{Logical (default FALSE) somatic copy number alterations data
from CGH.}

\item{Methylation}{Logical (default FALSE) methylation data.}

\item{Mutation}{Logical (default FALSE) mutation data from sequencing.}

\item{mRNAArray}{Logical (default FALSE) mRNA expression data from
microarray.}

\item{miRNAArray}{Logical (default FALSE) miRNA expression data from
microarray.}

\item{RPPAArray}{Logical (default FALSE) RPPA data}

\item{GISTIC}{logical (default FALSE) processed copy number data}

\item{RNAseqNorm}{RNAseq data normalization method. (Default raw_count)}

\item{RNAseq2Norm}{RNAseq v2 data normalization method. (Default
normalized_count or one of RSEM_normalized_log2, raw_count,
scaled_estimate)}

\item{forceDownload}{A logic (Default FALSE) key to force download
RTCGAToolbox every time. By default if you download files into your working
directory once than RTCGAToolbox using local files next time.}

\item{destdir}{Directory in which to store the resulting downloaded file.
Defaults to a cache directory given by \code{RTCGAToolbox:::.setCache()}.}

\item{fileSizeLimit}{Files that are larger than set value (megabyte) won't be
downloaded (Default: 500)}

\item{getUUIDs}{Logical key to get UUIDs from barcode (Default: FALSE)}

\item{...}{Additional arguments to pass down.}
}
\value{
A \code{FirehoseData} data object that stores data for selected data types.
}
\description{
\code{getFirehoseData} returns \code{FirehoseData} object that stores TCGA data.
}
\details{
This is a main client function to download data from Firehose TCGA portal.

To avoid unnecessary downloads, we use
\code{tools::R_user_dir("RTCGAToolbox", "cache")} to set the default \code{destdir}
parameter to the cached directory. To get the actual default directory,
one can run \code{RTCGAToolbox:::.setCache()}.
}
\examples{
# Sample Dataset
data(accmini)
accmini
\dontrun{
BRCAdata <- getFirehoseData(dataset="BRCA",
runDate="20140416",gistic2Date="20140115",
RNASeqGene=TRUE,clinical=TRUE,mRNAArray=TRUE,Mutation=TRUE)
}
}
\seealso{
\link{getLinks}, \url{https://gdac.broadinstitute.org/}
}
