% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapterremoval.R
\name{identify_adapters}
\alias{identify_adapters}
\title{identify adapters for paired-end reads}
\usage{
identify_adapters(file1, file2, ..., basename = NULL, overwrite = FALSE)
}
\arguments{
\item{file1}{\code{Character} vector. It can be file paths with #1
mates paired with file paths in file2
And it can also be interleaved file paths when argument
interleaved=\code{TRUE}}

\item{file2}{\code{Character} vector. It contains file paths with
#2 mates paired with file paths in file1.
For interleaved paired-end sequencing files(argument
interleaved=\code{TRUE}),it must to be setted to \code{NULL}.}

\item{...}{Additional arguments to be passed on to the binaries.
See below for details.}

\item{basename}{\code{Character}. The outputfile path prefix.
Default: your_output}

\item{overwrite}{\code{Logical}. Force overwriting of existing
files if setting \code{TRUE}.}
}
\value{
An invisible \code{Character} vector of adapters for each mate.
}
\description{
This function can be use to call wrapped \code{AdapterRemoval}
binary for adapters identifying.
}
\details{
All additional arguments in ... are interpreted as
additional parameters to be passed on to
identify_adapters. All of them should be \code{Character} or
\code{Numeric} scalar. You can put all aditional
arguments in one \code{Character}(e.g. "--threads 8") with white
 space splited just like command line,
or put them in different \code{Character}(e.g. "--threads","8").
Note that some arguments("--identify-adapters",
"--file1","--file2","--basename") to the
identify_adapters are invalid if they are already handled as
explicit function arguments. See the output of
\code{adapterremoval_usage()} for details about available parameters.
}
\examples{
td <- tempdir()
reads_1 <- system.file(package="Rbowtie2", "extdata", "adrm", "reads_1.fq")
reads_2 <- system.file(package="Rbowtie2", "extdata", "adrm", "reads_2.fq")
adapters <- identify_adapters(file1=reads_1,file2=reads_2,
basename = file.path(td,"reads")
,"--threads 2",overwrite=TRUE)
adapters
}
\references{
Schubert, Lindgreen, and Orlando (2016).
AdapterRemoval v2: rapid adapter trimming, identification, and read merging.
BMC Research Notes, 12;9(1):88.
}
\author{
Zheng Wei
}
