% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Misc.R
\docType{data}
\name{RedeR-data2}
\alias{RedeR-data2}
\alias{ER.limma}
\title{Pre-processed dataset for RedeR case studies.}
\format{
igraph
}
\source{
Carroll JS et al., Genome-wide analysis of estrogen receptor binding sites.
Nat Genet. 38(11):1289-97, 2006.

Castro MA et al. RedeR: R/Bioconductor package for representing modular
structures, nested networks and multiple levels of hierarchical
associations. Genome Biology, 13(4):R29, 2012.
}
\usage{
data(ER.limma)
}
\value{
A pre-processed dataset.
}
\description{
Preprocessed data from a time-course gene expression and
ChIP-on-chip analysis of estrogen receptor (ER) binding sites in the MCF7
cell line (Carroll et al, 2006).
}
\details{
The 'ER.limma' dataset contains results from a differential
gene expression analysis described elsewhere (Castro et al., 2012). This
dataset also includes annotation of ER-binding sites. The original gene
expression dataset (Carroll et al.) consists of 12 time-course
Affymetrix U133Plus2.0 microarrays: 3 replicates at 0h, 3 replicates at 3h,
3 replicates at 6h and 3 replicates at 12h. The original dataset is
available at the GEO database (GSE11324).

\describe{
\item{ER.limma}{ A data-frame containing pre-processed results from a
'limma' analysis listing the DE genes only. The data-frame columns list the
following information: annotation (ENTREZ and Symbol), time-course fold
change (logFC.t3, logFC.t6, logFC.t12), p values (p.value.t3, p.value.t6,
p.value.t12), DE genes (degenes.t3, degenes.t6, degenes.t12) and kb distance
of the nearest ER-binding site to the TSS (ERbdist). }
}
}
\examples{
data(ER.limma)
}
\keyword{ER}
