% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{results_expr}
\alias{results_expr}
\alias{results_DEA}
\alias{results_topNet}
\alias{results_enrich}
\alias{results_score}
\title{Result accessor functions}
\usage{
results_expr(object)

results_DEA(object)

results_topNet(object)

results_enrich(object)

results_score(object)
}
\arguments{
\item{object}{RegenrichSet object.}
}
\value{
results_expr retures an expression matrix.

results_DEA returns a list result of differentila analysis.

results_topNet returns a TopNetwork object.

results_enrich returns an Enrich object by either FET or GSEA
method.

results_score returns an data frame of summarized ranking scores
of regulators.
}
\description{
\itemize{
\item results_expr accesses raw expression data.
\item results_DEA accesses results from differential expression analysis.
\item results_topNet accesses results from network inference.
\item retults_enrich accesses results from FET/GSEA enrichment analysis.
\item results_score accesses results from regulator scoring and ranking.
}
}
\examples{
# library(RegEnrich)
data("Lyme_GSE63085")
data("TFs")

data = log2(Lyme_GSE63085$FPKM + 1)
colData = Lyme_GSE63085$sampleInfo

# Take first 2000 rows for example
data1 = data[seq(2000), ]

design = model.matrix(~0 + patientID + week, data = colData)

# Initializing a 'RegenrichSet' object
object = RegenrichSet(expr = data1,
                      colData = colData,
                      method = 'limma', minMeanExpr = 0,
                      design = design,
                      contrast = c(rep(0, ncol(design) - 1), 1),
                      networkConstruction = 'COEN',
                      enrichTest = 'FET')

\donttest{
# Differential expression analysis
object = regenrich_diffExpr(object)
results_expr(object)
results_DEA(object)

# Network inference using 'COEN' method
object = regenrich_network(object)
results_topNet(object)

# Enrichment analysis by Fisher's exact test (FET)
object = regenrich_enrich(object)
results_enrich(object)

# Regulators ranking
object = regenrich_rankScore(object)
results_score(object)
}
}
