% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeCluster.R
\docType{class}
\name{RnBClusterRun-class}
\alias{RnBClusterRun-class}
\title{RnBClusterRun Class}
\description{
A class for configuring and running RnBeads on a scientific compute cluster.
}
\section{Slots}{

\describe{
  \item{\code{architecture}}{A \code{\linkS4class{ClusterArchitecture}} object managing the settings for a scientific compute cluster}
  \item{\code{modules}}{A vector of pipeline modules} 
  \item{\code{module.res.req}}{Stores the resource requirements for each module. A list containing named vectors for the resources} 
  \item{\code{module.num.cores}}{Stores the number of cores for each module}
}
}

\section{Methods}{

\describe{
  \item{\code{\link{setModuleResourceRequirements,RnBClusterRun,character,character-method}}}{Sets the resource requirements for the different pipeline modules}
  \item{\code{\link{setModuleNumCores,RnBClusterRun,integer,character-method}}}{Sets the number of cores used by the different pipeline modules}
  \item{\code{\link{getModuleNumCores,RnBClusterRun-method}}}{Gets the number of cores used by the different pipeline modules}
  \item{\code{\link{run,RnBClusterRun-method}}}{Submit the pipeline modules to the cluster}
}
}

\author{
Fabian Mueller
}
