% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBDiffMeth-class.R
\docType{class}
\name{RnBDiffMeth-class}
\alias{RnBDiffMeth-class}
\title{RnBDiffMeth Class}
\description{
A class for storing differential methylation data.
}
\details{
Contains differential methylation tables (DMT) for multiple comparisons and region types. DMTs can be stored in memory
as R objects or on disk
}
\section{Slots}{

\describe{
  \item{\code{sites}}{List of differential methylation tables on site level (see \code{computeDiffMeth.bin.site} for details).
					Indexed by comparison.}
  \item{\code{regions}}{List of lists of differential methylation tables on region levels (see \code{computeDiffMeth.bin.region} for details).
					Indexed by region type on the top level and comparison on the lower level.}
  \item{\code{comparisons}}{character vector of all comparisons stored in the objects. Vector indices correspond to indices in the \code{sites} and
					\code{regions} list slots.}
  \item{\code{region.types}}{character vector of all region types stored in the objects. Vector indices correspond to indices in
					the \code{regions} list slot.}
  \item{\code{comparison.grouplabels}}{A character matrix with 2 columns containing group labels of all comparisons in the object}
  \item{\code{comparison.info}}{A list containing comparison information for each comparison. See \code{\link{get.comparison.info}} for details.}
  \item{\code{includesSites}}{Logical indicating whether the object contains site-level differential methylation information.}
  \item{\code{site.test.method}}{method which was applied to obtain the site-level p-values.}
  \item{\code{variability.method}}{method to be used to detect differentially variable sites.}
  \item{\code{covg.thres}}{coverage threshold. Important for certain columns of the differential methylation tables.}
  \item{\code{disk.dump}}{Flag indicating whether the tables should be stored on disk rather than in the main memory}
  \item{\code{disk.path}}{path on the disk for DMTs.Only meaningful if \code{disk.dump} is \code{TRUE}}
}
}

\section{Methods}{

\describe{
  \item{\code{\link{destroy,RnBDiffMeth-method}}}{remove tables stored to disk from the file system}
  \item{\code{\link{get.region.types,RnBDiffMeth-method}}}{Gets all region types represented in the object as character vector}
	 \item{\code{\link{get.comparisons,RnBDiffMeth-method}}}{Gets all comparisons represented in the object as character vector}
  \item{\code{\link{get.comparison.grouplabels,RnBDiffMeth-method}}}{Gets all comparison group names as a matrix}
  \item{\code{\link{get.covg.thres,RnBDiffMeth-method}}}{Gets the coverage threshold employed for obtaining statistics in the differential methylation tables}
  \item{\code{\link{get.table,RnBDiffMeth-method}}}{Gets a differential methylation table}
  \item{\code{\link{addDiffMethTable,RnBDiffMeth-method}}}{Adds a differential methylation table}
	 \item{\code{\link{reload,RnBDiffMeth-method}}}{relink disk dumped tables. Useful if the files are manually copied or if the object is loaded again}
  \item{\code{\link{save.tables,RnBDiffMeth-method}}}{save disk dumped tables as binaries and zip them.
						Useful if the files are copied or shared.}
  \item{\code{\link{join.diffMeth}}}{Merges two disjoint RnBDiffMeth objects into one}
}
}

\author{
Fabian Mueller
}
