% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBeadSet-class.R
\docType{class}
\name{RnBeadSet-class}
\alias{RnBeadSet-class}
\alias{RnBeadSet}
\alias{initialize,RnBeadSet-method}
\title{RnBeadSet Class}
\usage{
RnBeadSet(
  pheno,
  probes,
  betas,
  p.values = NULL,
  bead.counts = NULL,
  qc = NULL,
  platform = "450k",
  summarize.regions = TRUE,
  region.types = rnb.region.types.for.analysis(ifelse(platform == "MMBC", "mm10",
    rnb.getOption("assembly"))),
  useff = rnb.getOption("disk.dump.big.matrices")
)
}
\arguments{
\item{pheno}{Phenotypic data.}

\item{probes}{\code{character} vector of Infinium(R) probe identifiers}

\item{betas}{\code{matrix} or \code{ff_matrix} of beta values. If \code{probes} are missing should contain Infinium probe identifiers as row names.}

\item{p.values}{\code{matrix} or \code{ff_matrix} of detection p-values.}

\item{bead.counts}{...}

\item{qc}{...}

\item{platform}{\code{character} singleton specifying the microarray platform: \code{"450k"} corresponds to HumanMethylation450 microarray, and \code{"27k"} stands for HumanMethylation27.}

\item{summarize.regions}{...}

\item{region.types}{A \code{character} vector specifying the region types, for which the methylation infromation will be summarized.}

\item{useff}{If \code{TRUE} the data matrices will be stored as \code{ff} objects}
}
\value{
an object of class RnBeadSet
}
\description{
Stores the preprocessed information from HumanMethylation experiments
}
\details{
There are multiple ways to create an object of type \code{RnBeadSet}:
\describe{
 \item{Loading from files}{Dataset can be loaded from text or binary files. See the function
      \code{\link{rnb.execute.import}} for more details.}
 \item{Downloading from GEO}{See the function \code{\link{rnb.read.geo}} for details.}
 \item{Converting from \code{MethyLumiSet}}{...}
}
}
\section{Slots}{

\describe{
  \item{\code{pval.sites}}{\code{matrix} of detection p-values with the same dimensions as \code{betas}, or
       \code{NULL} if the detection p-values are not available.}
  \item{\code{pval.regions}}{\code{list} of methylation \code{matrix} objects, one per available region type. Every row in a 
		matrix corresponds to a methylation site, and every column - to a sample.}
  \item{\code{covg.sites}}{\code{matrix} of bead counts per probe with the same dimensions as \code{betas}, or
       \code{NULL} if this data are not available.}
  \item{\code{qc}}{Quality control probe information in the form of a \code{list} of two elements - \code{"Cy3"} and
       \code{"Cy5"}, storing intensities of probes on the green and red channels, respectively. This slot's value is
       \code{NULL} if no control probe information is available.}
}
}

\section{Methods and Functions}{

\describe{
  \item{\code{\link[=samples,RnBSet-method]{samples}}}{Gets the identifiers of all samples in the dataset.}
  \item{\code{\link[=pheno,RnBSet-method]{pheno}}}{Gets the phenotypic and processing data of the dataset.}
  \item{\code{\link[=meth,RnBSet-method]{meth}}}{Gets the \code{matrix} of methylation beta-values of the dataset.}
  \item{\code{\link[=dpval,RnBeadSet-method]{dpval}}}{Gets the \code{matrix} of detection p-values of the dataset.}
  \item{\code{\link[=covg,RnBSet-method]{covg}}}{Gets the \code{matrix} of bead counts of the dataset.}
  \item{\code{\link[=qc,RnBeadSet-method]{qc}}}{Gets the intensities of the quality control probes.}
  \item{\code{\link[=remove.sites,RnBSet-method]{remove.sites}}}{Removes probes from the dataset.}
  \item{\code{\link[=remove.samples,RnBeadSet-method]{remove.samples}}}{Removes samples from the dataset.}
  \item{\code{\link[BiocGenerics]{combine}}}{Combines two datasets.}
}
}

\author{
Pavlo Lutsik
}
