% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{combine.rnb.sets,RnBSet,RnBSet-method}
\alias{combine.rnb.sets,RnBSet,RnBSet-method}
\alias{combine.rnb.sets}
\alias{combine.rnb.sets,RnBSet-method}
\title{combine.rnb.sets-methods}
\usage{
\S4method{combine.rnb.sets}{RnBSet,RnBSet}(x, y, type = "all")
}
\arguments{
\item{x, y}{\code{\linkS4class{RnBeadSet}}, \code{\linkS4class{RnBeadRawSet}}
or \code{\linkS4class{RnBiseqSet}} object}

\item{type}{\code{character} singleton defining the set operation applied to the two site sets, 
one of "all", "all.x", "all.y" or "common"}
}
\value{
combined \code{\linkS4class{RnBeadSet}}, \code{\linkS4class{RnBeadRawSet}} or
\code{\linkS4class{RnBiseqSet}} object
}
\description{
Combine two objects inheriting from \code{\linkS4class{RnBSet}} class
}
\details{
Combine method supports a merge of any two RnBSet objects that contain data of the same specie.
In case a non-synonymous merge is performed, the class conversion will follow the following hierarchy: 
\code{\linkS4class{RnBeadSet}} < \code{\linkS4class{RnBeadRawSet}} < \code{\linkS4class{RnBiseqSet}}.
In case \code{x} and \code{y} are both array data containers (\code{RnBeadSet} or \code{RnBeadRawSet}), 
the resulting object will have an annotation that corresponds to the newer array version 
(\code{27k} < \code{450k} < \code{EPIC} < \code{EPICv2}).
The sample sets of \code{x} and \code{y} should be unique. Sample annotation information is merged only for columns 
which have identical names in both objects. CpG sites of the new object are a union of those present in both objects.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
r1 <- rnb.set.example
r1 <- remove.samples(r1,samples(rnb.set.example)[1:5])
i <- which(r1@sites[,2] == 15 | r1@sites[,2] == 21)
sites.rem.r1 <- union(sample(1:nrow(meth(rnb.set.example)),500),i)
r1 <- remove.sites(r1,sites.rem.r1)
r2 <- rnb.set.example
r2 <- remove.samples(r2,samples(rnb.set.example)[6:12])
sites.rem.r2 <- sample(1:nrow(meth(rnb.set.example)),800)
r2 <- remove.sites(r2,sites.rem.r2)
rc <- combine.rnb.sets(r1,r2)
#assertion: check the number of sites
sites.rem.c <- intersect(sites.rem.r1,sites.rem.r2)
(nrow(meth(rnb.set.example))-length(sites.rem.c)) == nrow(meth(rc))
}
}
