% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialMethylation.R
\name{computeDiffTab.default.region}
\alias{computeDiffTab.default.region}
\alias{computeDiffTab.region}
\title{computeDiffTab.region}
\usage{
computeDiffTab.default.region(dmtp, regions2sites, includeCovg = FALSE)
}
\arguments{
\item{dmtp}{differential methylation table on the site level (as obtained from \code{\link{computeDiffTab.default.site}})}

\item{regions2sites}{a list containing for each region the indices of the corresponding sites in the site differential methylation table}

\item{includeCovg}{flag indicating whether to include coverage information}
}
\value{
a dataframe containing the following variables for a given genomic region:
\item{mean.mean.g1,mean.mean.g2}{mean of mean methylation levels for group 1 and 2 across all sites in a region}
\item{mean.mean.diff}{Mean difference in means across all sites in a region}
\item{mean.mean.quot.log2}{Mean quotient in means across all sites in a region}
\item{comb.p.val}{Combined p-value using a generalization of Fisher's method. See \code{\link{combineTestPvalsMeth}} for details.}
\item{comb.p.adj.fdr}{FDR adjusted combined p-value}
\item{num.sites}{number of sites that were considered for a region}
\item{mean.num.na.g1/2}{mean number (accross all considered sites) of samples that contained an NA for group 1 and 2 respectively}
\item{mean.mean.covg.g1/2}{Mean value of mean coverage values (across all samples in a group) across all sites in a region}
\item{mean.nsamples.covg.thresh.g1/2}{mean number (accross all considered sites) of samples that have a coverage larger than the specified threshold
		(see \code{\link{computeDiffTab.default.site}} for details) for group 1 and 2 respectively}
}
\description{
computes a difference table containing multiple difference measures,
In the simple version the mean of the difference in means,
the mean quotient in means and a combination of p-values on the site level are computed.
This is computed for each row of the input table. The extended version contains additional columns
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
meth.mat <- meth(rnb.set.example)
sample.groups <- rnb.sample.groups(rnb.set.example)[[1]]
dm.sites <- computeDiffTab.extended.site(meth.mat,sample.groups[[1]],sample.groups[[2]])
map.regions.to.sites <- regionMapping(rnb.set.example,"promoters")
dm.promoters <- computeDiffTab.default.region(dm.sites,map.regions.to.sites)
}
}
\author{
Fabian Mueller
}
