% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{downloadLolaDbs}
\alias{downloadLolaDbs}
\title{downloadLolaDbs}
\usage{
downloadLolaDbs(dest, dbs = c("LOLACore"))
}
\arguments{
\item{dest}{destination directory}

\item{dbs}{vector of names of LOLA DBs to be downloaded. Currently 'LOLACore' and 'LOLAExt'
are supported}
}
\value{
a list containing vectors of directory names for each available genome assembly
}
\description{
Downloading prepared LOLA DBs from server
}
\details{
Requires a stable internet connection. Could take a while depending on the size of the database and the internet connection
}
\examples{
\donttest{
lolaDest <- tempfile()
dir.create(lolaDest)
lolaDirs <- downloadLolaDbs(lolaDest, dbs="LOLACore")
}
}
\author{
Fabian Mueller
}
