% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialMethylation.R
\name{get.comparison.info}
\alias{get.comparison.info}
\title{get.comparison.info}
\usage{
get.comparison.info(
  x,
  pheno.cols = rnb.getOption("differential.comparison.columns"),
  region.types = rnb.region.types.for.analysis(x),
  pheno.cols.all.pairwise = rnb.getOption("differential.comparison.columns.all.pairwise"),
  columns.pairs = rnb.getOption("columns.pairing"),
  columns.adj = rnb.getOption("covariate.adjustment.columns"),
  adjust.sva = rnb.getOption("differential.adjustment.sva"),
  pheno.cols.adjust.sva = rnb.getOption("inference.targets.sva"),
  adjust.celltype = rnb.getOption("differential.adjustment.celltype"),
  adjust.na.rm = TRUE
)
}
\arguments{
\item{x}{\code{RnBSet} object}

\item{pheno.cols}{column names of the pheno slot in \code{x} on which the dataset should be partitioned. Those columns are required to be factors or logical.
In case of factors, each group in turn will be compared to all other groups}

\item{region.types}{which region types should be processed for differential methylation}

\item{pheno.cols.all.pairwise}{integer or character vector specifying the colomns of \code{pheno(x)} on which all pairwise comparisons should be conducted.
A value of \code{NULL} indicates no columns.}

\item{columns.pairs}{argument passed on to \code{rnb.sample.groups}. See its documentation for details.}

\item{columns.adj}{Column names or indices in the table of phenotypic information to be used for confounder adjustment in the
differential methylation analysis.}

\item{adjust.sva}{flag indicating whether the adjustment table should also contain surrogate variables (SVs) for the given target variable.}

\item{pheno.cols.adjust.sva}{Target variables for SVA adjustment. Only important if \code{adjust.sva==TRUE}. Only the intersection of
\code{pheno.cols} and \code{pheno.cols.adjust.sva} is considered for SVA adjustment.}

\item{adjust.celltype}{flag indicating whether the resulting table should also contain estimated celltype contributions.
See \code{\link{rnb.execute.ct.estimation}} for details.}

\item{adjust.na.rm}{Flag indicating whether NAs in the adjustment table should be removed.}
}
\value{
a list containing one element for each comparison to be conducted. Each element is again a list containing:
\describe{
  \item{\code{comparison}}{the name of the comparison}
  \item{\code{pheno.colname}}{the column name of the sample annotation table the comparison is derived from}
  \item{\code{group.names}}{the names of the two groups being compared}
  \item{\code{group.inds}}{the sample indices of the samples belonging to the two groups}
  \item{\code{paired}}{flag indicating whether paired analysis is conducted}
  \item{\code{adj.sva}}{flag indicating whether adjustment for SVA is conducted}
  \item{\code{adj.celltype}}{flag indicating whether adjustment for cell type is conducted}
  \item{\code{adjustment.table}}{the covariate adjustment table. \code{NULL} if the comparison is not adjusted}
  \item{\code{region.types}}{the region types applicable to the analysis}
}
}
\description{
retrieve the comparison information for an RnBSet object
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
cmp.info <- get.comparison.info(rnb.set.example,pheno.cols=c("Sample_Group","Treatment"))
cmp.info[[1]]
}
}
\author{
Fabian Mueller
}
