% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterArchitectureSLURM.R
\docType{methods}
\name{getSubCmdTokens,ClusterArchitectureSLURM-method}
\alias{getSubCmdTokens,ClusterArchitectureSLURM-method}
\title{getSubCmdTokens-methods}
\usage{
\S4method{getSubCmdTokens}{ClusterArchitectureSLURM}(
  object,
  cmd.tokens,
  log,
  job.name = "",
  res.req = character(0),
  depend.jobs = character(0),
  sub.binary = TRUE,
  quote.cmd = TRUE
)
}
\arguments{
\item{object}{\code{\linkS4class{ClusterArchitectureSLURM}} object}

\item{cmd.tokens}{a character vector specifying the executable command that should be wrapped in the cluster submission command}

\item{log}{file name and path of the log file that the submitted job writes to}

\item{job.name}{name of the submitted job}

\item{res.req}{named vector of requested resources. Two options are available: \code{"clock.limit"} and \code{"memory.size"}}

\item{depend.jobs}{character vector containg names or ids of jobs the submitted job will depend on.}

\item{sub.binary}{flag indicating if the command is to be submitted using the \code{"wrap"} option of SLURM}

\item{quote.cmd}{Flag indicating whether the submitted cammed should also be wrapped in quotes}
}
\value{
A character vector containing the submission command tokens
}
\description{
Returns a string for the of command line corresponding to submitting
a job with the given command to the cluster.
}
\details{
For a concrete child class implementation for a SLURM architecture specification see \code{\linkS4class{ClusterArchitectureSLURM}}
}
\examples{
\donttest{
arch <- new("ClusterArchitectureSLURM",
	name="my_slurm_architecture"
)
getSubCmdTokens(arch,c("Rscript","my_great_script.R"),"my_logfile.log")
}
}
\author{
Michael Scherer
}
