% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedycut.R
\name{greedycut.filter.matrix}
\alias{greedycut.filter.matrix}
\title{greedycut.filter.matrix}
\usage{
greedycut.filter.matrix(mm, rows2ignore = integer(), rc.ties = "row")
}
\arguments{
\item{mm}{Numeric matrix to filter.}

\item{rows2ignore}{\code{integer} vector containing indices of rows in \code{mm} to be ignored by this  function.}

\item{rc.ties}{Flag indicating what the behaviour of the algorithm should be in case of ties between values of
rows and columns. The value of this parameter must be one of \code{"row"}, \code{"column"} or
\code{"any"} (the last one indicating random choice).}
}
\value{
Table summarizing the iterations of the algorithm in the form of a \code{data.frame} with the following
        columns : Index, Type, Score, Normalized score, Rows, Columns.
}
\description{
Performs all iterations of the Greedycut algorithm for removing rows and columns from the given matrix.
}
\seealso{
\code{\link{greedycut.get.submatrix}} for extracting the resulting matrix after filtering
}
\author{
Yassen Assenov
}
