% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialMethylation.R
\name{limmaP}
\alias{limmaP}
\title{limmaP}
\usage{
limmaP(
  X,
  inds.g1,
  inds.g2 = -inds.g1,
  adjustment.table = NULL,
  fun.conversion = rnb.beta2mval,
  paired = FALSE
)
}
\arguments{
\item{X}{Matrix on which the test is performed for every row}

\item{inds.g1}{column indices of group 1 members}

\item{inds.g2}{column indices of group 2 members}

\item{adjustment.table}{a \code{data.frame} containing variables to adjust for in the testing}

\item{fun.conversion}{conversion function to transform the beta values into M values. By default, it is the logit function with adjustment
for infinity values. See \code{\link{rnb.beta2mval}} for details.}

\item{paired}{should a paired analysis model be used. If so, the first index in \code{inds.g1} must correspond to the first
index in  \code{inds.g2} and so on.}
}
\value{
vector of p-values resulting from limma's differential analysis
}
\description{
applies hierarchical modeling anlalogous to differential expression employed in the \code{limma} package and returns
p-values for differential methylation
}
\note{
Requires \code{limma} package
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
meth.mat <- meth(rnb.set.example)
sample.groups <- rnb.sample.groups(rnb.set.example)[[1]]
p.vals <- limmaP(meth.mat,sample.groups[[1]],sample.groups[[2]])
}
}
\author{
Fabian Mueller
}
