% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{mergeSamples,RnBSet-method}
\alias{mergeSamples,RnBSet-method}
\alias{mergeSamples}
\title{mergeSamples}
\usage{
\S4method{mergeSamples}{RnBSet}(object, grp.col)
}
\arguments{
\item{object}{input RnBSet object}

\item{grp.col}{a column name (string) of \code{pheno(rnb.set)} that contains unique identifiers for sample groups/replicates
to be combined}
}
\value{
the modified RnBSet object
}
\description{
Take an RnBSet object and merge methylation and phenotype information given a grouping column in the pheno table
coverage is combined by taking the sum of coverages
pheno is combined by concatenating entries from all samples
}
\details{
combines phenotype information, coverage information and methylation information
methylation is combined by taking the average. Detection p-values are combined using Fisher's method.
For methylation arrays, bead counts are currently not taken into account.
objects of class \code{RnBeadRawSet} are automatically converted to \code{RnBeadSet}.
}
\note{
Requires the packages \pkg{foreach} and \pkg{doParallel}.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.set.example
rnb.set.merged <- mergeSamples(rnb.set.example,"Cell_Line")
rnb.set.merged
pheno(rnb.set.merged)
}
}
\author{
Fabian Mueller
}
