% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportGEO.R
\name{prepareSOFTfileForGEO}
\alias{prepareSOFTfileForGEO}
\title{prepareSOFTfileForGEO}
\usage{
prepareSOFTfileForGEO(
  rnb.set,
  filename,
  sample.source.col = NULL,
  sample.description.col = NULL,
  sample.title.col = NULL,
  export.cols = seq(ncol(pheno(rnb.set))),
  rnb.set.raw = NULL,
  sample.extra.info = NULL,
  series.info = NULL
)
}
\arguments{
\item{rnb.set}{Object inheriting from class \code{RnBeadSet}
with \code{"GSE"}.}

\item{filename}{Absolute path or a name of a SOFT file to be generated}

\item{sample.source.col}{\code{integer} singleton specifying a column in the \code{pheno} slot of \code{rnb.set} 
containing information which will be written into the field \code{Sample_source_name_ch1}
of each sample record}

\item{sample.description.col}{\code{integer} singleton specifying a column in the \code{pheno} slot of \code{rnb.set} 
containing information which will be written into the field \code{Sample_desription}
of each sample record}

\item{sample.title.col}{\code{integer} singleton specifying a column in the \code{pheno} slot of \code{rnb.set} 
containing information which will be written into the field \code{Sample_title}
of each sample record. If \code{NULL}, the result of \code{samples(rnb.set)} will be used}

\item{export.cols}{\code{integer} vector specifying columns in the \code{pheno} slot of \code{rnb.set} 
containing information which will be written into the fields \code{Sample_characteristics_ch1}
of each sample record}

\item{rnb.set.raw}{Object inheriting from class \code{RnBeadSet}}

\item{sample.extra.info}{Optionally, a \code{list} with elements to be written to all series record. Elements should be character
singletons named with valid SOFT labels of a SAMPLE section, e.g.\code{Sample_extract_protocol}, 
\code{Sample_hyb_protocol}, \code{Sample_label_protocol_ch1}, \code{Sample_data_processing}, 
\code{Sample_contact_name}, \code{Sample_contact_email} etc.}

\item{series.info}{A \code{list} with elements to be written to the series record. Elements should be character
singletons named \code{SERIES} (contains a valid GSE identifier for updating an existing series)
\code{Series_title}, \code{Series_summary}, \code{Series_type}, \code{Series_overall_design},
\code{Series_contributor}, \code{Series_sample_id}}
}
\value{
\code{TRUE} on success.
}
\description{
Starting from an \code{RnBeadSet} object generates a batch submission file for Gene Expression Omnibus series in SOFT format
}
\details{
The code was largely adapted from a similar function in package \code{lumi} which is due to Pan Du.
}
\author{
Pavlo Lutsik
}
