% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rnb.annotation.size}
\alias{rnb.annotation.size}
\title{rnb.annotation.size}
\usage{
rnb.annotation.size(type = "CpG", assembly = "hg19")
}
\arguments{
\item{type}{Name of annotation. Control probe annotations are not accepted.}

\item{assembly}{Genome assembly of interest. See \code{\link{rnb.get.assemblies}} for the list of supported genomes.}
}
\value{
\code{integer} vector showing the number of elements the specified annotation contains per chromosome. The
        names of the vector are the names of \code{\link{rnb.get.chromosomes}} for the given genome assembly.
        Chromosomes that are not covered by the annotation have their respective value set to \code{0} (zero).
}
\description{
Gets the size, in number of genomic elements, of the specified annotation.
}
\examples{
\donttest{
library(RnBeads.hg19)
rnb.annotation.size("probes450")
}
}
\seealso{
\code{\link{rnb.region.types}} for a list of supported region annotations
}
\author{
Yassen Assenov
}
