% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rnb.beta2mval}
\alias{rnb.beta2mval}
\title{rnb.beta2mval}
\usage{
rnb.beta2mval(betas, epsilon = 1e-05)
}
\arguments{
\item{betas}{\code{numeric} vector or matrix of beta values to be transformed.}

\item{epsilon}{Single \code{numeric} in the range [0, 0.5], giving the threshold of beta values to use when
adjusting for potential M values close to +infinity or -infinity. Setting this parameter to 0 (zero)
disables stabilization; in which case M values of -infinity or +infinity could be returned.}
}
\value{
The calculated and adjusted M values.
}
\description{
Transforms beta values to M values, adjusting for +infinity and -infinity.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
mvals <- rnb.beta2mval(meth(rnb.set.example))
summary(mvals)
}
}
\author{
Fabian Mueller
}
