% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExport.R
\name{rnb.execute.export.csv}
\alias{rnb.execute.export.csv}
\title{rnb.execute.export.csv}
\usage{
rnb.execute.export.csv(
  rnb.set,
  output.location,
  region.types = rnb.getOption("export.types")
)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{output.location}{\code{character} or \code{\linkS4class{Report}} specifying the output directory. If this is a
report, the output directory is set to be a subdirectory named \code{csv} of the report's data
directory. Set this parameter to the empty string (\code{""}) or \code{NA} to use the current
working directory. If the given path does not exist, this function attempts to create it.}

\item{region.types}{\code{character} vector indicating region types to be exported.}
}
\value{
\code{character} vector containing the names of the files to which data were exported; prepended by
        \code{output.location}. In case a certain region type could not be exported (see the \emph{Details} section),
        the corresponding element of this vector is \code{NA}.
}
\description{
Exports (selected) methylation tables of the given dataset to comma-separated value files.
}
\details{
The names of the generated output files are formed by the prefix \code{"betas_"}, followed by a number between
1 and \code{length(region.types)}. The extension is \code{.csv} or \code{.csv.gz}, depending on the value of the
\pkg{RnBeads} option \code{"gz.large.files"}. Any such files that already exist in the output directory, are
overwritten.

There are several reasons why a certain output file cannot be (fully) generated. Examples for failures are listed
below:
\itemize{
  \item{}{The corresponding region type is invalid.}
  \item{}{The corresponding region type is not supported by the dataset. If the type is loaded in \pkg{RnBeads},
          use the \code{\link[=summarize.regions,RnBSet-method]{summarize.regions}} method prior to calling this function,
          in order to include the support of this region type in the dataset.}
  \item{}{Due to security restrictions, the creation of files in the output directory is not allowed.}
  \item{}{A file or directory with the same name exists and cannot be overwritten.}
  \item{}{The disk is full or the user quota is exceeded.}
}
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.execute.export.csv(rnb.set.example, "", summarized.regions(rnb.set.example))
}
}
\author{
Yassen Assenov
}
