% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sva.R
\name{rnb.execute.sva}
\alias{rnb.execute.sva}
\title{rnb.execute.sva}
\usage{
rnb.execute.sva(
  rnb.set,
  cmp.cols = rnb.getOption("inference.targets.sva"),
  columns.adj = rnb.getOption("covariate.adjustment.columns"),
  assoc = TRUE,
  numSVmethod = rnb.getOption("inference.sva.num.method")
)
}
\arguments{
\item{rnb.set}{The \code{RnBSet} object on which the SVA should be conducted}

\item{cmp.cols}{a vector of sample annotation column names which will be the targets of the SVA.}

\item{columns.adj}{Column names in the table of phenotypic information to be used for confounder adjustment.}

\item{assoc}{a flag indicating whether association information with principal components and other sample annotation should
be returned}

\item{numSVmethod}{method to estimate the number of surrogate variables. Passed to \code{sva}.}
}
\value{
An object of class \code{SvaResult}: basically a list containing the following elements:
\describe{
  \item{\code{num.components}}{a vector storing the number of detected SVs for each target variable}
  \item{\code{sva.performed}}{a vector storing whether SVA was performed on a target variable and whether more than 0 SVs were found}
  \item{\code{targets}}{a vector storing the names of the target variables}
  \item{\code{components}}{a list storing for each target variable a matrox containing the sample-wise SVs as rows}
  \item{\code{assoc}}{a special object containing association information of SVs with principal components and sample annotations
 typically only used \code{rnb.section.sva}.}
}
}
\description{
Conduct Surrogate Variable Analysis (SVA) on the beta values of an RnBSet for given target variables
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
sva.obj <- rnb.execute.sva(rnb.set.example,c("Sample_Group","Treatment"),numSVmethod="be")
sva.obj$sva.performed
sva.obj$num.components
rnb.set.mod <- set.covariates.sva(rnb.set.example, sva.obj)
has.covariates.sva(rnb.set.example,"Sample_Group")
has.covariates.sva(rnb.set.mod,"Sample_Group")
has.covariates.sva(rnb.set.mod,"Treatment")
}
}
\author{
Fabian Mueller
}
