% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Report-methods.R
\name{rnb.get.reference}
\alias{rnb.get.reference}
\title{rnb.get.reference}
\usage{
rnb.get.reference(report, txt)
}
\arguments{
\item{report}{Report that contains the reference to be cited.}

\item{txt}{Text of the reference in the form of a non-empty \code{character} vector. This reference must already
added to the report.}
}
\value{
Citation of the reference item (including a link) in the form of a one-element \code{character} vector. If
        the specified reference item is not found in the report, this method returns an empty string.
}
\description{
Creates a string that points to the given reference item in the specified report.
}
\examples{
\donttest{
report <- createReport("example.html", "Example", init.configuration = TRUE)
txt.reference <- c("Bird A. ", "<i>Nucleic Acids Res.</i> <b>8</b> (1980)")
report <- rnb.add.reference(report, txt.reference)
txt <- c("This was shown in ", rnb.get.reference(report, txt.reference), ".")
rnb.add.paragraph(report, txt)
}
}
\seealso{
\code{\link{rnb.add.reference}} for adding a reference item to a report; \code{\linkS4class{Report}} for
  other functions adding contents to an HTML report
}
\author{
Yassen Assenov
}
