% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlPlotsBiSeq.R
\name{rnb.plot.coverage.thresholds}
\alias{rnb.plot.coverage.thresholds}
\title{rnb.plot.coverage.thresholds}
\usage{
rnb.plot.coverage.thresholds(rnb.set, min.coverages, fname = NA, ...)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type \code{\linkS4class{RnBiseqSet}}.}

\item{min.coverages}{Non-empty \code{integer} vector storing the unique positive cutoff values to be applied for
minimal coverage. Names, if present, are interpreted as colors that must be used to denote the
corresponding values.}

\item{fname}{File name to save the generated plot to. See the \emph{Details} section for restrictions.}

\item{...}{Additional named parameters related to saving the plot to files. These can include:
\code{report}, \code{width}, \code{height}, \code{create.pdf}, \code{low.png} and
\code{high.png}. These parameters are ignored when \code{fname} is \code{NULL} or \code{NA}.}
}
\value{
If \code{fname} is \code{NULL} or \code{NA} (default), the generated plot as an object of type
        \code{ggplot2}; otherwise, the initialized and closed \code{\linkS4class{ReportPlot}} object, invisibly.
}
\description{
Plots the number of remaining CpGs after applying different thresholds for coverage and support.
}
\details{
If \code{fname} is specified, this function calls \code{\link{createReportPlot}} to save the plot to PDF and/or PNG
files. See \link[=createReportPlot]{its documentation} for information on acceptable file names. Additional
parameters - \code{report}, \code{width}, \code{height}, etc. - can also be given. If image width is not specified,
it is set to a value between 4.7 and 9.2 (inches), depending on the number of samples in the dataset. The default
image height is fixed to 7.2.
}
\author{
Yassen Assenov
}
