% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingUtils.R
\name{rnb.plot.dreduction}
\alias{rnb.plot.dreduction}
\title{rnb.plot.dreduction}
\usage{
rnb.plot.dreduction(
  rnb.set,
  plot.type = "pca",
  dimensions = 1:2,
  distance.metric = "euclidean",
  target = "sites",
  point.types = 0L,
  point.colors = 0L,
  legend.space = 2
)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}. This dataset
must contain at least four samples.}

\item{plot.type}{Type of plot to be created. This must be one of \code{"pca"} (projection to two principal
components), \code{"mds"} (multidimensional scaling to two dimensions) or \code{"tsne"}
(t-distributed stochastic neighbor embedding to two dimensions). The section
\emph{Details} provides more details on how the dimension reduction techniques are applied.}

\item{dimensions}{Vector of two positive \code{integer} values giving the principle components to be shown in
the horizontal and vertical axis of the plot. This parameter is considered only when
\code{plot.type} is \code{"pca"}.}

\item{distance.metric}{Distance metric to be applied when reducing the dimensionality of the methylation data. This
must be one of \code{"eucledian"} or \code{"manhattan"}. The second metric is not supported by
principal component analysis.}

\item{target}{Site or region type to be used in the dimension reduction technique. This must be either
\code{"sites"} (individual CpGs) or one of the region types summarized in \code{rnb.set}.}

\item{point.types}{Trait, specified as column name or index in the sample annnotation table of \code{rnb.set}, to
be used to define point types in the plot. Setting this parameter to zero (default) or to a
trait that does not define categories results in all samples being displayed as filled
circles. If this parameter specifies a column that can be used as sample identifiers, the plot
displays the samples as identifiers instead of points.}

\item{point.colors}{Trait, specified as column name or index in the sample annnotation table of \code{rnb.set}, to
be used to define sample colors in the plot. Setting this parameter to zero (default) or to a
trait that does not define numerical values or categories results in all samples being
displayed in black.}

\item{legend.space}{Width, in inches, of the space dedicated for legends that will be assigned on the right side
of the plot. This parameter is considered only if legends are actually included, that is, if
sample traits are mapped to point types and/or colors.}
}
\value{
The generated plot as an object of type \code{\link[ggplot2:ggplot]{ggplot}}. The object also contains an
        attribute \code{"info"}, which is a list with the following elements:
        \describe{
          \item{\code{"Target" }}{Targeted sites or regions; the value of the parameter \code{target}.}
          \item{\code{"Technique" }}{Dimension reduction technique applied; one of \code{"PCA"} or \code{"MDS"}.}
          \item{\code{"All" }}{Total number of sites or regions defining the high dimensional methylation space.}
          \item{\code{"Missing" }}{Number of dimensions ignored because they contain (only) missing values.}
          \item{\code{"Selected" }}{Number of dimensions used when applying a dimension reduction technique.}
          \item{\code{"Explained" }}{Value between \code{0} and \code{1} showing the variance explained by the
            selected dimensions, as a fraction of the total variance of all dimensions.}
        }
}
\description{
Creates a dimension reduction plot based on the methylation values of the given dataset.
}
\details{
The analysis option \code{"exploratory.top.dimensions"} controls whether dimension reduction is applied on all
probes, sites or regions available in the given dataset, or only on the most variable ones. In case a trait is mapped
to point types, the shapes to use are taken from the option \code{"points.category"}. Similary, the option
\code{"colors.category"} determines which colors are used when mapping sample categories to color. In cases when
numerical values are mapped to color, the option \code{"colors.3.gradient"} is used. If the set of value contains
both positive and negative numbers, the middle point in the color legend is set to zero. See
\emph{\link[=rnb.options]{RnBeads Options}} for more information on the options mentioned above.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
pdf("PCA.pdf", width = 7.2, height = 5.2)
print(rnb.plot.dreduction(rnb.set.example, point.colors="Sample_Group"))
dev.off()
}
}
\seealso{
\code{\link[=summarized.regions,RnBSet-method]{summarized.regions}} for listing all region types summarized
         in a dataset
}
\author{
Yassen Assenov
}
