% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionProfiles.R
\name{rnb.plot.region.profiles}
\alias{rnb.plot.region.profiles}
\title{rnb.plot.region.profiles}
\usage{
rnb.plot.region.profiles(
  rnb.set,
  group.index.list,
  region.type = "",
  region.profile = NULL,
  extend.by = 0.33,
  cvalues = rnb.getOption("colors.category")
)
}
\arguments{
\item{rnb.set}{RnBSet object}

\item{group.index.list}{a list (preferably named) containing sample indices for each group
a list of such lists is for instance generated by the \code{rnb.sample.groups} function.}

\item{region.type}{Region type for which the plot should be generated}

\item{region.profile}{Alternative to specifying \code{region.type}, the function can accept a region profile
generated by the \code{rnb.find.relative.site.coord} function}

\item{extend.by}{A number between 0 and 1 specifying the percentage by which a region is
extended in order to capture methylation information before region start and after region end}

\item{cvalues}{Color values that will be assigned to sample groups}
}
\value{
a ggplot2 object for plotting
        the plot shows the smoothed methylation levels of sites accross the specified region type for 
        all regions of that type from 0 (region start) to 1 (region end). Sites in the flanking areas are
        also shown (coordinates <0 and >1).
        Smoothing is stratified by sample (dashed lines) and sample group (thick solid lines).
        Cubic splines are used for smoothing
}
\description{
Creates a composite plot showing the sample and groupwise smoothed estimates
of methylation values accross all regions of the specified type
}
\examples{
\donttest{
#Careful: this might take a while
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.plot.region.profiles(rnb.set.example,rnb.sample.groups(rnb.set.example)[[1]],"genes")
}
}
\author{
Fabian Mueller
}
