% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlPlots.R
\name{rnb.plot.snp.barplot}
\alias{rnb.plot.snp.barplot}
\title{rnb.plot.snp.barplot}
\usage{
rnb.plot.snp.barplot(
  dataset,
  probeID,
  writeToFile = FALSE,
  numeric.names = FALSE,
  ...
)
}
\arguments{
\item{dataset}{Dataset as an instance of \code{\linkS4class{RnBeadRawSet}} or \code{\linkS4class{RnBeadSet}}.
Alternatively, the dataset can be specified as a non-empty \code{matrix} containing the computed
beta values on the SNP probes.}

\item{probeID}{Probe identifier. This must be one of \code{rownames(meth(dataset))}.}

\item{writeToFile}{Flag specifying whether the output should be saved as \code{\linkS4class{ReportPlot}}.}

\item{numeric.names}{if \code{TRUE} and \code{writeToFile} is \code{TRUE}substitute the plot options in the plot file
name with digits.}

\item{...}{Additional named arguments passed to \code{\link{createReportPlot}}.}
}
\value{
plot as an object of type \code{\linkS4class{ReportPlot}} if \code{writeToFile} is \code{TRUE} and of class
			\code{\link{ggplot}} otherwise.
}
\description{
Bar plots of beta-values from the genotyping probes
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
samp<-samples(rnb.set.example)[1]
rnb.plot.snp.barplot(rnb.set.example, samp)
}
}
\author{
Pavlo Lutsik
}
