% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controlPlots.R
\name{rnb.plot.snp.heatmap}
\alias{rnb.plot.snp.heatmap}
\title{rnb.plot.snp.heatmap}
\usage{
rnb.plot.snp.heatmap(dataset, writeToFile = FALSE, ...)
}
\arguments{
\item{dataset}{Dataset as an object of type inheriting \code{\linkS4class{RnBeadSet}}, or a matrix of
methylation beta values.}

\item{writeToFile}{Flag specifying whether the output should be saved as \code{\linkS4class{ReportPlot}}.}

\item{...}{Additional named arguments passed to \code{\link{createReportPlot}}. These are used only if
\code{writeToFile} is \code{TRUE}.}
}
\value{
If \code{writeToFile} is \code{TRUE}, plot as an object of type \code{\linkS4class{ReportPlot}}. Otherwise,
        there is no value returned (invisible \code{NULL}).
}
\description{
Heatmap of beta values from genotyping probes.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.plot.snp.heatmap(rnb.set.example)
}
}
\author{
Pavlo Lutsik
}
