% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rnb.save.annotation}
\alias{rnb.save.annotation}
\title{rnb.save.annotation}
\usage{
rnb.save.annotation(fname, type, assembly = "hg19")
}
\arguments{
\item{fname}{One-element \code{character} vector giving the name of the file to contain the annotation data. If
this file already exists, it will be overwritten.}

\item{type}{One-element \code{character} vector giving the name of the region annotation.}

\item{assembly}{Genome assembly of interest. See \code{\link{rnb.get.assemblies}} for the list of supported genomes.}
}
\value{
\code{TRUE}, invisibly.
}
\description{
Saves the specified region annotation table and its accompanying data structures to a binary file.
}
\details{
This function is used in combination with \code{\link{rnb.load.annotation}} to enable fast reloading of custom region
annotations. If can also be used to save a build-in region annotation (e.g. before overwriting it) but not site or
control probe annotations.
}
\seealso{
\code{\link{rnb.load.annotation}} for loading a saved annotation
}
\author{
Yassen Assenov
}
