% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{rnb.xml2options}
\alias{rnb.xml2options}
\title{rnb.xml2options}
\usage{
rnb.xml2options(fname, return.full.structure = FALSE)
}
\arguments{
\item{fname}{File name containing the XML analysis option values. The name of the root node in this document must be
\code{"rnb.xml"}.}

\item{return.full.structure}{if enabled, return the full structure instead of just the option list}
}
\value{
List of two sublists - \code{"analysis.params"} and \code{"options"}, storing the specified analysis
        parameters and previous values of the RnBeads options, respectively.
}
\description{
Parses and partially validates parameters and RnBeads options from an XML tree.
}
\examples{
\donttest{
fname <- paste0("extdata/optionProfiles/",profile,".xml")
rnb.xml2options(system.file(fname,package="RnBeads"))
}
}
\author{
Yassen Assenov
}
