% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{summarize.regions,RnBSet-method}
\alias{summarize.regions,RnBSet-method}
\alias{summarize.regions}
\title{summarize.regions-methods}
\usage{
\S4method{summarize.regions}{RnBSet}(
  object,
  region.type,
  aggregation = rnb.getOption("region.aggregation"),
  overwrite = TRUE
)
}
\arguments{
\item{object}{Dataset of interest.}

\item{region.type}{Type of the region annotation for which the summarization will be performed or \code{"strands"} for summarizing the methylation values from both strands}

\item{aggregation}{Operation to summarize the methylation values. Currently supported values are \code{"mean"}, \code{"median"}, \code{"min"}, \code{"max"} and \code{"coverage.weighted"}}

\item{overwrite}{If \code{TRUE} the existing region-level information for \code{region.type} is discarded}
}
\value{
object of the same class as the supplied one containing the summarized methylation information for the specified region types
}
\description{
Summarize DNA methylation information for which is present in the \code{RnBSet} object.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.set.summarized<-summarize.regions(rnb.set.example, "genes", overwrite=TRUE)
head(meth(rnb.set.summarized, type="genes", row.names=TRUE))
}
}
