% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{timeAlign}
\alias{timeAlign}
\alias{timeAlign,Rnits-method}
\alias{timeAlign,character,ANY-method}
\title{Curve registration of time series curves}
\usage{
timeAlign(object, iterMax = 5, seed = 123, null.frac = 0.75,
  anchor = NULL, rerun = FALSE, plot = FALSE)

\S4method{timeAlign}{Rnits}(object, iterMax = 5, seed = 123,
  null.frac = 0.75, anchor = NULL, rerun = FALSE, plot = FALSE)
}
\arguments{
\item{object}{\code{rnits} object}

\item{iterMax}{Maximum iterations to be performed}

\item{seed}{Random seed}

\item{null.frac}{Fraction of genes that are considered as null}

\item{anchor}{Sample to be considerded as base for aligning time series. If not provided, the average is used}

\item{rerun}{If \code{TRUE}, re-align previously aligned data}

\item{plot}{If \code{TRUE}, plot results}
}
\description{
Align multiple time series to the average seris
}
\examples{
# load pre-compiled expressionSet object for Ronen and Botstein yeast  chemostat data
data(yeastchemostat)
rnitsobj = build.Rnits(yeastchemostat, logscale = TRUE, normmethod = 'Between')

# Do curve-registration on data
rnitsobj <- timeAlign(rnitsobj)
}

