% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkpoint.R
\name{checkpoint}
\alias{checkpoint}
\title{Save time storing longer analysis step on disk}
\usage{
checkpoint(
  label,
  CODE,
  path = ".",
  overwrite = FALSE,
  verbose = FALSE,
  keep = NULL
)
}
\arguments{
\item{label}{name of this code, will create a Rda file with the same name.}

\item{CODE}{R code.}

\item{path}{directory to write/load Rda file.}

\item{overwrite}{Rerun CODE and replace Rda file.}

\item{verbose}{argument passed to load function}

\item{keep}{vector of object/variable name to keep. NULL means error.}
}
\value{
Nothing.
}
\description{
This utility function can be used to save time on task that takes long time
to complete. A Rda file are written on disk containing only objects setted
to keep. If checkpoint function find related Rda file then this Rda will be
loaded.
}
\note{
Experimental function.
}
\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")

}
\author{
Welliton Souza
}
