% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.utilities.R
\name{highlightPath}
\alias{highlightPath}
\title{Highlight shortest path between two nodes}
\usage{
highlightPath(
  from.node = NULL,
  to.node = NULL,
  directed.graph = TRUE,
  node.set.id.type = "compound.name",
  glyphs.id.type = "pathwayCommons",
  mol.type = "cpd",
  input.node.stroke.width = 10,
  from.node.color = "red",
  to.node.color = "blue",
  path.node.color = "black",
  path.node.stroke.width = 10,
  n.shortest.paths.plot = 1,
  shortest.paths.cols = c("purple"),
  path.stroke.width = 2,
  tip.size = 4
)
}
\arguments{
\item{from.node}{A character string. The molecule ID of source node.}

\item{to.node}{A character string. The molecule ID of target node.}

\item{directed.graph}{Logical. If treat the SBGN map as a directed graph. If treat it as directed graph, the direction of an arc is determined by the <arc> XML element in the input SBGN-ML file: from 'source' node to 'target' node.}

\item{node.set.id.type}{A character string. Default: "compound.name". ID type of input nodes.}

\item{glyphs.id.type}{A character string. Default: "pathwayCommons". ID type of nodes in SBGN-ML file.}

\item{mol.type}{A character string. One of 'gene' or 'cpd' (default).}

\item{input.node.stroke.width}{Integer. Default: 10. Border stroke width of input nodes (affects both from.node and to.node)}

\item{from.node.color}{A character string. Default: "red". Border color of 'source'/from.node}

\item{to.node.color}{A character string. Default: "blue". Border color of 'target'/to.node}

\item{path.node.color}{A character string. Default: "black". Border color of nodes in the path.}

\item{path.node.stroke.width}{Integer. Default: 10. Adjust stroke width of path between nodes.}

\item{n.shortest.paths.plot}{Integer. Default: 1. There could be more than one shortest paths between two nodes. User can choose how many of them to plot.}

\item{shortest.paths.cols}{A vector of character string. Default: c("purple"). The colors of arcs in different shortest paths. The length of this vector (number of colors) should be the value of n.shortest.paths.plot. If one arc is in multiple shortest paths, its color will be set to the color that appears later in this vector.}

\item{path.stroke.width}{Integer. Default: 2. The width of line in edges in the shortest paths.}

\item{tip.size}{Integer. Default: 4. The size of arc tip in edges of the shortest paths.}
}
\value{
A SBGNview obj
}
\description{
Given two nodes, find the shortest path between them and highlight the path. Other molecules/nodes and edges involved in reactions in the path are also highlighted. This function should be used as the second argument to function. Run \code{help("+.SBGNview")} for more information.
}
\examples{
\dontrun{
obj.new <- SBGNview.obj + highlightPath(from.node = c('tyrosine'), 
                                        to.node = c('dopamine'),
                                        from.node.color = 'red',
                                        to.node.color = 'blue')
}
}
