# SCnorm: robust normalization of single-cell RNA-seq data

SCnorm is an R package which can be used to normalize single-cell RNA-seq data. SCnorm is on Bioconductor and instructions for download may be found at [https://bioconductor.org/packages/release/bioc/html/SCnorm.html](https://bioconductor.org/packages/release/bioc/html/SCnorm.html).

#### Can you use SCnorm on your 10X (or very sparse) dataset?

SCnorm is not intended for datasets with more than ~80% zero counts, often K will not converge in these situations. 
Setting the FilterExpression parameter to 1 or 2 may help, but is not a guarantee. 
It may also be helpful to use the ditherCounts = TRUE parameter for sparse UMI based data which may contain numerous tied counts (counts of 1 and 2 for example).

Additional details and a FAQ for SCnorm are described in the vignette: [SCnorm Vignette](https://bioconductor.org/packages/release/bioc/vignettes/SCnorm/inst/doc/SCnorm.pdf)

## Installation

Make sure to use the latest version of SCnorm by installing it from BioConductor or GitHub. 

```R
if (!requireNamespace("BiocManager", quietly=TRUE))
    install.packages("BiocManager")
BiocManager::install("SCnorm")
```
or

```R
library(devtools)
devtools::install_github("rhondabacher/SCnorm")
```
To access a version of SCnorm that does not require R version >= 3.4 you can 
download SCnorm from the development branch here: 
[https://github.com/rhondabacher/SCnorm/tree/devel](https://github.com/rhondabacher/SCnorm/tree/devel)


## Author

Rhonda Bacher <rhonda.bacher@gmail.com>

## Cite
Please cite SCnorm if you use it in your research:

> Bacher R, Chu LF, Leng N, Gasch AP, Thomson JA, Stewart RM, Newton M, 
Kendziorski C. SCnorm: robust normalization of single-cell
RNA-seq data. Nature Methods. 2017 Jun 1;14(6):584-6.
[https://www.nature.com/nmeth/journal/v14/n6/full/nmeth.4263.html](https://www.nature.com/nmeth/journal/v14/n6/full/nmeth.4263.html)



## Latest Update: v1.5.7
Added additional warnings when using the useSpikes option and SCnorm now supports input data in the sparse matrix format.

#### Previous updates: v1.5.4
Allow separate normalizations for different Conditions for very large dataset. See vignette for example.


