% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{TxFeatures}
\alias{TxFeatures}
\title{Transcript features}
\usage{
TxFeatures(x, type = mcols(x)$type, txName = mcols(x)$txName,
  geneName = mcols(x)$geneName)
}
\arguments{
\item{x}{\code{GRanges} with known strand (\dQuote{+}, \dQuote{-})}

\item{type}{Character vector or factor, taking value
\code{J}, \code{I}, \code{F}, \code{L}, or \code{U}}

\item{txName}{\code{CharacterList} of transcript names or \code{NULL}}

\item{geneName}{\code{CharacterList} of gene names or \code{NULL}}
}
\value{
\code{TxFeatures} object
}
\description{
Creates an instance of S4 class \code{TxFeatures} for storing
transcript features.
}
\details{
\code{TxFeatures} extends \code{GRanges} with column slot \code{type}
specifying feature type. \code{type} is a factor with levels
\code{J} (splice junction), \code{I} (internal exon),
\code{F} (5' terminal exon), \code{L} (3' terminal exon),
\code{U} (unspliced transcript).

\code{txName} and \code{geneName} are CharacterLists storing
transcript and gene annotation, respectively.
}
\examples{
gr <- GRanges(1, IRanges(101, 200), "+")
txf <- TxFeatures(gr, type = "J")
}
\author{
Leonard Goldstein
}
