% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{analyzeVariants}
\alias{analyzeVariants}
\title{Analysis of splice variants}
\usage{
analyzeVariants(object, maxnvariant = 20, include = "default",
  min_denominator = NA, min_anchor = 1, cores = 1)
}
\arguments{
\item{object}{\code{SGFeatureCounts} object}

\item{maxnvariant}{If more than \code{maxnvariant} variants are
identified in an event, the event is skipped, resulting in a warning.
Set to \code{NA} to include all events.}

\item{include}{Character string indicating whether identified splice
variants should be filtered. Possible options are \dQuote{default}
(only include variants for events with all variants closed),
\dQuote{closed} (only include closed variants) and \dQuote{all}
(include all variants).}

\item{min_denominator}{Integer specifying minimum denominator when
calculating variant frequencies. The total number of boundary-spanning
reads must be equal to or greater than \code{min_denominator} for at
least one event boundary. Otherwise estimates are set to \code{NA}.
If \code{NA}, all estimates are returned.}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{cores}{Number of cores available for parallel processing}
}
\value{
\code{SGVariantCounts} object
}
\description{
High-level function for the analysis of splice variants from
splice graph features. Splice variants are identified with
\code{\link{findSGVariants}}. Representative counts are obtained
and variant frequencies estimated with \code{\link{getSGVariantCounts}}.
}
\examples{
sgvc <- analyzeVariants(sgfc_pred)
}
\author{
Leonard Goldstein
}
