% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{annotate}
\alias{annotate}
\title{Annotation with respect to transcript features}
\usage{
annotate(query, subject)
}
\arguments{
\item{query}{\code{SGFeatures}, \code{SGVariants},
\code{SGFeatureCounts} or \code{SGVariantCounts} object}

\item{subject}{\code{TxFeatures} object}
}
\value{
\code{query} with updated \code{txName}, \code{geneName}
  column slots
}
\description{
Features in \code{query} are assigned transcript names and gene names
of structurally compatible features in \code{subject} (see below).
If a feature in \code{query} does not match any features in
\code{subject}, its geneName inherits from connected annotated features.
}
\details{
Feature matching is performed as follows:
Query splice junctions are matched with identical subject splice
junctions. Query splice sites are matched with splice sites
implied by subject splice junctions. Query exon bins are matched with
overlapping subject exons. Spliced boundaries of query exon bins
must match spliced subject exon boundaries. Query exon bins cannot
extend across spliced subject exon boundaries.
}
\examples{
sgf_annotated <- annotate(sgf_pred, txf_ann)
sgv_annotated <- annotate(sgv_pred, txf_ann)
}
\author{
Leonard Goldstein
}
